--[[
Copyright (C) GtX (Andy), 2024

Author: GtX | Andy
Date: 20.12.2024
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Free for use in mods (FS25 Only) - no permission needed.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy

Frei verwendbar (Nur LS25) - keine erlaubnis nötig
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
]]

HandToolHPWLanceExtensionEvent = {}

local HandToolHPWLanceExtensionEvent_mt = Class(HandToolHPWLanceExtensionEvent, Event)
InitEventClass(HandToolHPWLanceExtensionEvent, "HandToolHPWLanceExtensionEvent")

function HandToolHPWLanceExtensionEvent.emptyNew()
    local self = Event.new(HandToolHPWLanceExtensionEvent_mt)

    return self
end

function HandToolHPWLanceExtensionEvent.new(object, isActivated)
    local self = HandToolHPWLanceExtensionEvent.emptyNew()

    self.object = object
    self.isActivated = isActivated

    return self
end

function HandToolHPWLanceExtensionEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)
    self.isActivated = streamReadBool(streamId)

    self:run(connection)
end

function HandToolHPWLanceExtensionEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
    streamWriteBool(streamId, self.isActivated)
end

function HandToolHPWLanceExtensionEvent:run(connection)
    if self.object ~= nil and self.object.setIsActivated ~= nil then
        self.object:setIsActivated(self.isActivated)
    end
end
